<!DOCTYPE html>
<html lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">
 <title>National Catalogue of Crop Varieties</title>
    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
 
     <link href="https://fonts.googleapis.com/css?family=Rubik:400,500,700" rel="stylesheet">

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
	  <link href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body>

    <!-- Spinner End -->


    <!-- Navbar Start -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light shadow border-top border-5 border-primary sticky-top p-0">
        <a href="index.php" class="navbar-brand bg-primary d-flex align-items-center px-4 px-lg-5">
            <h2 class="mb-2 text-white">Crop Catalogue</h2>
        </a>
        <button type="button" class="navbar-toggler me-4" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarCollapse">
            <div class="navbar-nav ms-auto p-4 p-lg-0">
                <a href="index.php" class="nav-item nav-link active">Home</a>
				 <a href="catalogue.php" class="nav-item nav-link active">Catalogue</a>
	 <a href="filterResult.php" class="nav-item nav-link active">Filter</a>
  <a href="contact.html" class="nav-item nav-link">Contact</a>
                    </div>
                </div>
  
            </div>
            <h4 class="m-0 pe-lg-5 d-none d-lg-block"><i class="fa fa-headphones text-primary me-3"></i>+233 54232 8997</h4>
        </div>
    </nav>
    <!-- Navbar End -->


    <!-- Page Header Start -->
    <div class="container-fluid page-header py-5" style="margin-bottom: 6rem;">
        <div class="container py-5">
            <h1 class="display-3 text-white mb-3 animated slideInDown">Filter</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a class="text-white" href="index.php">Home</a></li>
           

                </ol>
            </nav>
        </div>
    </div>

    <div class="container container-fluid overflow-hidden py-5 px-lg-0">
             <div class="row">
                 <span>Select year range to filter</span>
		     <div class="col-md-4">
		 
   <div class="input-group mb-3">
  <input type="text" name="from" id="startYear" class="form-control" placeholder="From" required>
   <input type="text" class="form-control" id="endYear"placeholder="To" name="to" required >
  <button class="btn btn-outline-secondary" onclick="fetchDataAndRenderChart()">Filter</button>

</div>
</div>
		 
</div>
<div style="width: 80%; margin: auto;">
   <canvas id="cropChart"></canvas>
</div>
<script>
        let cropChart; // Variable to store the chart instance

        // Function to fetch data and render the chart
        function fetchDataAndRenderChart() {
            const startYear = document.getElementById('startYear').value;
            const endYear = document.getElementById('endYear').value;

            if (!startYear || !endYear) {
                alert("Please enter both start and end years.");
                return;
            }

            // Fetch data from PHP script with year range
            fetch(`fetch_data.php?startYear=${startYear}&endYear=${endYear}`)
                .then(response => response.json())
                .then(data => {
                    renderChart(data);
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        // Function to render the chart
        function renderChart(data) {
            const years = data.map(item => item.year_released); // Extract years
            const totalCrops = data.map(item => item.total_crops); // Extract total crops

            const ctx = document.getElementById('cropChart').getContext('2d');

            // Destroy existing chart instance if it exists
            if (cropChart) {
                cropChart.destroy();
            }

            // Render the chart
            cropChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: years,
                    datasets: [{
                        label: 'Total ',
                        data: totalCrops,
                        backgroundColor: 'rgba(75, 192, 192, 0.2)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Total Varieties Released'
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Harvest Year'
                            }
                        }
                    }
                }
            });
        }
    </script>


        </div>
    </div>
    <!-- About End -->



    <!-- Feature End -->



    <!-- Team End -->
        

     <div class="container-fluid bg-dark text-light footer pt-5 wow fadeIn" data-wow-delay="0.1s" style="margin-top: 6rem;">
     
        <div class="container">
            <div class="copyright">
                <div class="row">
                    <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                        &copy; <a class="border-bottom" href="#">National Catlogue Of Crop Varieties</a>, All Right Reserved.
                    </div>
                    <div class="col-md-6 text-center text-md-end">
                        <!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
                        Designed By <a class="border-bottom" href="https://htmlcodex.com">CSIR - CROPS RESEARCH INSTITUTE</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer End -->


    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-0 back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/counterup/counterup.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
</body>

</html>