<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>National Catalogue of Crop Varieties</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&family=Roboto:wght@500;700&display=swap" rel="stylesheet">

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
	  <link href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.min.css" rel="stylesheet">
</head>

<body>
    <!-- Spinner Start -->
    <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
        <div class="spinner-grow text-primary" style="width: 3rem; height: 3rem;" role="status">
            <span class="sr-only">Loading...</span>
        </div>
    </div>
    <!-- Spinner End -->


    <!-- Navbar Start -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light shadow border-top border-5 border-primary sticky-top p-0">
        <a href="index.php" class="navbar-brand bg-primary d-flex align-items-center px-4 px-lg-5">
            <h2 class="mb-2 text-white">Crop Catalogue</h2>
        </a>
        <button type="button" class="navbar-toggler me-4" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarCollapse">
            <div class="navbar-nav ms-auto p-4 p-lg-0">
                <a href="index.php" class="nav-item nav-link active">Home</a>
				 <a href="catalogue.php" class="nav-item nav-link active">Catalogue</a>

                    </div>
                </div>
                <a href="contact.html" class="nav-item nav-link">CONTACT</a>
            </div>
            <h4 class="m-0 pe-lg-5 d-none d-lg-block"><i class="fa fa-headphones text-primary me-3"></i>+233 54232 8997</h4>
        </div>
    </nav>
    <!-- Navbar End -->

	  <?php
require('connection.php');
$id = $_GET['id'];
$view = "SELECT * from details WHERE md5(nationalcode) = '$id'";
$result = $db_link->query($view);
$row = $result->fetch_assoc();?>
    <!-- Page Header Start -->
    <div class="container-fluid page-header py-5" style="margin-bottom: 6rem;">
        <div class="container py-5">
            <h1 class="display-3 text-white mb-3 animated slideInDown"><?php echo $row['variety'];?></h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a class="text-white" href="index.php">Home</a></li>
           
               
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- About Start -->
    <div class="container container-fluid overflow-hidden py-5 px-lg-0">
        <div class="container about py-5 px-lg-0">
			<div class="col-md-12 col-8 text-center m-b-30">
                        <div class="btn-group btn-group-sm">
                            <button class="btn btn-white">DOCX</button>
                            <button class="btn btn-white">PDF</button>
                            <button class="btn btn-white"><i class="fa fa-print fa-lg"></i> Print</button>
							  
                        </div>
                    </div>
		 <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                <h6 class="text-secondary text-uppercase">NATIONAL CATALOGUE OF CROP VARIETIES 2019</h6>
                <h1 class="mb-5"><?php echo $row['variety'];?></h1>
			
            </div>
			  
           <div class="row">
            <div class="col-md-12">
			    <table class="table table-bordered table-striped" width="100%" style="">
                                            <tbody>
                                                <tr>
													<th>Name of variety</th>
                                                    <td><?php echo $row['variety'];?></td>
                                                </tr>
                                                <tr>
											<th>Commodity</th>
                                                    <td><?php echo $row['commodity'];?></td>
                                                </tr>
                                                <tr>
												<th>National Code</th>
                                                    <td><?php echo $row['nationalcode'];?></td>
                                                </tr>
                                                <tr>
												<th>Origin/Source</th>
                                                    <td><?php echo $row['origin'];?></td>
                                                </tr>
                                                <tr>
												<th>Applicant</th>
                                                    <td><?php echo $row['applicant'];?></td>
                                                </tr>
												  <tr>
												  <th>Preferred Ecology</th>
                                                    <td><?php echo $row['ecology'];?></td>
                                                </tr>
												  <tr>
												  <th>Pedigree/Line</th>
                                                    <td><?php echo $row['pedigree'];?></td>
                                                </tr>
												  <tr>
												  <th>Year of release</th>
                                                    <td><?php echo $row['year_released'];?></td>
                                                </tr>
												  <tr>
												  <th>Year of registry</th>
                                                    <td><?php echo $row['year_registry'];?></td>
                                                </tr>
												
                                            </tbody>
                                        </table>
										          <div>
									  <?php
require('connection.php');
$id = $_GET['id'];
$view = "SELECT * FROM traits WHERE md5(nationalcode) = '$id'";
$result = $db_link->query($view);
$row = $result->fetch_assoc();?>
                                        
									  <table class="table table-bordered table-striped" style="color:">
                                            <tbody>
                                                <tr>
												 <th>Distinctness, Uniformity and Stability</th>
                                                    <td><?php echo $row['distinctness'];?></td>
                                                </tr>
                                                <tr>
												 <th>Value for cultivation and use</th>
                                                    <td><?php echo $row['vcu'];?></td>
                                                </tr>
                                                
                                            </tbody>
                                        </table>
										

										    
										
                                    </div>
									 <h4 class="m-b-10 alert alert-default"><strong>BREEDERS</strong></h4>
								
										 	 <table class='table table-hover text-nowrap table-striped'>
                  <thead>
                    <tr>
                   
                     
                      <th>Name</th>
                     
                  
                    </tr>
                  </thead>
                  <tbody>
				   <?php
require('connection.php');
$view = "SELECT * FROM breeders WHERE md5(nationalcode) = '$id'";
$result = $db_link->query($view);
if($result->num_rows > 0){
while($row = $result->fetch_array()){?>
                  <tr>
                    <td><?php echo $row['name']; ?></td>
             
                   
                  </tr>
               
                        <?php
					
							}

						}else{
							echo " <div class='alert alert-success alert-dismissible'>
	       <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                     
          NO RECORD FOUND
                    </div>";
						}
					
				$db_link->close();
				?>
                  </tbody>
                </table>
			
			</div>
		
 <div class="col-sm-12">
								        <h4 class="m-b-10 alert alert-default"><strong>PHOTOS</strong></h4>
								  <div class="row">
                    
										 <hr>
				
				   <?php
require('connection.php');
$view = "SELECT * FROM photos WHERE md5(nationalcode) = '$id'";
$result = $db_link->query($view);
if($result->num_rows > 0){
while($row = $result->fetch_array()){?>

                        <div class="col-md-3 text-center">
              <?php  echo " <a href='data:image/jpeg;base64," . $row['path'] . "' alt='" . htmlspecialchars($row['nationalcode'], ENT_QUOTES, 'UTF-8') . "' data-toggle='lightbox' data-title='' data-gallery='gallery'> ";?>
               <?php  
			   echo "<img src='data:image/jpeg;base64," . $row['path'] . "' alt='" . htmlspecialchars($row['nationalcode'], ENT_QUOTES, 'UTF-8') . "' style='width:200px;height:200px;'>";
                       ?>
					   </a> 
					   </div>
              
               
                        <?php
					
							}

						}else{
							echo " <div class='alert alert-success alert-dismissible'>
	       <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                     
          NO RECORD FOUND
                    </div>";
						}
					
				$db_link->close();
				?>
               
				  </div>
			
                                </div>
			
			
			
			</div>
		
		
			
        </div>
        </div>
    </div>
    <!-- About End -->



    <!-- Feature End -->



    <!-- Team End -->
        

     <div class="container-fluid bg-dark text-light footer pt-5 wow fadeIn" data-wow-delay="0.1s" style="margin-top: 6rem;">
     
        <div class="container">
            <div class="copyright">
                <div class="row">
                    <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                        &copy; <a class="border-bottom" href="#">National Catlogue Of Crop Varieties</a>, All Right Reserved.
                    </div>
                    <div class="col-md-6 text-center text-md-end">
                        <!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
                        Designed By <a class="border-bottom" href="https://htmlcodex.com">CSIR - CROPS RESEARCH INSTITUTE</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer End -->


    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-0 back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/counterup/counterup.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
	    <script src="https://cdn.datatables.net/2.1.8/js/dataTables.min.js"></script>
		<script>
		let table = new DataTable('#example1');
		</script>
</body>

</html>